--[[---------------------------------------------------------------------------
	Chocolatier Two Main UI
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Global UI Definitions
require("ui/styles.lua")
require("ui/uihelp.lua")
require("ui/uiconstants.lua")
require("ui/numericentry.lua")

-- Simulator and Data
require("sim/sim.lua")

-- First Peek Hook
if fpWrite then
	fpWriteReal = fpWrite
	fpWrite = function(data)
		local event = data[1]
		local dataString = table.concat(data, ",", 2)
		fpWriteReal(event,dataString)
	end
end

-- Main game loop
function Main()
	-- Show splash screens
	if gChocoSplash ~= 0 then
		-- AOL web version shows AOL logo over splash screen
		if gAOLFlag == 1 then
			SetDefaultStyle { splashoverlay = Bitmap { x=5, y=270, image="splash/aol_web_logo" } }
			DisplaySplash("splash/playfirst_animated_logo.swf", "splash/playfirst_logo",4000)
			SetDefaultStyle(standardStyle)
		else
			DisplaySplash("splash/playfirst_animated_logo.swf", "splash/playfirst_logo",4000)
		end
	
		DisplaySplash("", "splash/bigsplash_logo",3000)
		DisplaySplash("", "splash/distributor_logo",3000)
	end
	
	LoadSound("buy")
	LoadSound("sell")

	-- Initialize simulator data
	Simulator:Initialize()

	-- Start some initial random seed, hopefully it will be somewhat variable
	bsgRandomSeed()
	
	-- Push the game selection screen
	while true do
		DoMainWindow("ui/mainmenu.lua");
		-- DoMainWindow will exit only if there are NO windows pushed on the stack, so
		-- a PopModal()/PushModal() combination will not cause this to loop.
	end
end

-- Return a function to be executed in a thread
return Main
